/**
 * 
 */
package com.ejie.ab18a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aErrorAplicacion;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * @author XXXX
 * 
 */
@Transactional()
@Repository()
public class Ab18aErrorAplicacionDaoImpl implements Ab18aErrorAplicacionDao {

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aErrorAplicacion> rwMap = new RowMapper<Ab18aErrorAplicacion>() {
		public Ab18aErrorAplicacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aErrorAplicacion(resultSet.getInt("ID"), resultSet.getString("CODERROR"), resultSet.getString("DESCRIPCIONERROR"),
					resultSet.getString("DESCRIPCIONEU"));
		}
	};

	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the ab18a16s00 table.
	 * 
	 * @param error
	 *            ab18a16s00
	 * @return ab18a16s00
	 */
	@Transactional(readOnly = true)
	@Override()
	public Ab18aErrorAplicacion find(Ab18aErrorAplicacion error) {
		String query = "SELECT t1.T16_ID_ERROR ID, t1.T16_COD_ERROR CODERROR, t1.T16_DESC_ERROR_ES DESCRIPCIONERROR, t1.T16_DESC_ERROR_EU DESCRIPCIONEU FROM AB18A16S00 t1 WHERE t1.T16_ID_ERROR = ?";

		List<Ab18aErrorAplicacion> ab18a16s00List = this.jdbcTemplate.query(query, this.rwMap, error.getId());
		return (Ab18aErrorAplicacion) DataAccessUtils.uniqueResult(ab18a16s00List);
	}

	@Override
	@Transactional(readOnly = true)
	public List<Ab18aErrorAplicacion> findAll(Ab18aErrorAplicacion filtroError, JQGridRequestDto jqGridRequestDto) {
		Boolean startsWith = false;

		StringBuilder query = new StringBuilder(
				"SELECT  t1.T16_ID_ERROR ID, t1.T16_COD_ERROR CODERROR, t1.T16_DESC_ERROR_ES DESCRIPCIONERROR, t1.T16_DESC_ERROR_EU DESCRIPCIONEU ");
		query.append("FROM AB18A16S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filtroError, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aErrorAplicacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional
	public Ab18aErrorAplicacion update(Ab18aErrorAplicacion error) {
		String query = "UPDATE AB18A16S00 SET T16_COD_ERROR=?, T16_DESC_ERROR_ES=?, T16_DESC_ERROR_EU=? WHERE T16_ID_ERROR=?";
		this.jdbcTemplate.update(query, error.getCodError(), error.getDescripcionError(), error.getDescripcionEu(), error.getId());
		return error;
	}

	@Override
	@Transactional
	public Ab18aErrorAplicacion add(Ab18aErrorAplicacion error) throws DataAccessException, Exception {
		String query = "INSERT INTO AB18A16S00 (T16_ID_ERROR, T16_COD_ERROR, T16_DESC_ERROR_ES, T16_DESC_ERROR_EU) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, this.getNextSequenceValue("SQAB18A16"), error.getCodError(), error.getDescripcionError(),
				error.getDescripcionEu());
		return error;
	}

	/**
	 * Counts rows in the Ab18a06s00 table.
	 * 
	 * @param error
	 *            Ab18aErrorAplicacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aErrorAplicacion error) {
		Boolean startsWith = false;

		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A16S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(error, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a06s00 entity
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aErrorAplicacion filtroError, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aTipoBoletinDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Utilidades.notNullAndNotEmpty(filtroError.getCodError())) {
			where.append(" AND UPPER(t1.T16_COD_ERROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroError.getCodError() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(filtroError.getCodError().toUpperCase()) + "%");
			}
			where.append(" AND t1.T16_COD_ERROR IS NOT NULL");
		}

		if (Utilidades.notNullAndNotEmpty(filtroError.getDescripcionError())) {
			where.append(" AND UPPER(t1.T16_DESC_ERROR_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroError.getDescripcionError() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(filtroError.getDescripcionError().toUpperCase()) + "%");
			}
			where.append(" AND t1.T16_DESC_ERROR_ES IS NOT NULL");
		}

		if (Utilidades.notNullAndNotEmpty(filtroError.getDescripcionEu())) {
			where.append(" AND UPPER(t1.T16_DESC_ERROR_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroError.getDescripcionEu() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(filtroError.getDescripcionEu().toUpperCase()) + "%");
			}
			where.append(" AND t1.T16_DESC_ERROR_EU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Transactional(readOnly = true)
	public long findErrorByCod(String codEnvio) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A16S00 t1 ");

		// Where clause & Params
		StringBuilder whereBuilder = new StringBuilder(Ab18aTipoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		whereBuilder.append(" AND UPPER(t1.T16_COD_ERROR) = ?");
		params.add(codEnvio.toUpperCase());

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(whereBuilder);
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
